#ifndef LANG_CN_H
#define LANG_CN_H

// ========== MENSAJES DE suite_kiss.ino ==========
#define LANG_HELLO_MESSAGE "🔌 你好。\n通信已建立\n\n🔨 编译时间: %s\n🔢 哈希: 0x%08X\n📦 版本: %s\n📊 状态:\n重启次数: %d\n运行时间: %lu 秒\n可用内存: %d 字节\n待处理消息: %d\n📡 WiFi信号: %d dBm (%s)"

// WiFi信号质量
#define LANG_WIFI_EXCELLENT "优秀"
#define LANG_WIFI_GOOD "良好"
#define LANG_WIFI_FAIR "一般"
#define LANG_WIFI_WEAK "弱"

// /estado 命令
#define LANG_STATUS_TITLE_RELIABILITY "🎯 系统可靠性"
#define LANG_STATUS_SYSTEM "系统"
#define LANG_STATUS_RELIABLE "可靠"
#define LANG_STATUS_CHECK "检查"
#define LANG_STATUS_SENT "已发送消息"
#define LANG_STATUS_PENDING "待处理消息"
#define LANG_STATUS_LOST "丢失消息"
#define LANG_STATUS_DISCARDED "已丢弃（队列已满）"
#define LANG_STATUS_TITLE_EXTERNAL "🌐 外部困难"
#define LANG_STATUS_ERRORS "总错误数"
#define LANG_STATUS_RECOVERED "已恢复（后备）"
#define LANG_STATUS_WIFI_DROPS "WiFi断开"
#define LANG_STATUS_TITLE_TECHNICAL "📊 技术信息"
#define LANG_STATUS_UPTIME "运行时间"
#define LANG_STATUS_FREE_RAM "可用内存"
#define LANG_STATUS_FREE_PSRAM "可用PSRAM"
#define LANG_STATUS_FREE_FS "可用FS"
#define LANG_STATUS_MAX_FS "FS最大值"
#define LANG_STATUS_MESSAGES "消息"
#define LANG_STATUS_POWER_MODE "电源模式"
#define LANG_STATUS_WIFI_SIGNAL "WiFi信号"
#define LANG_STATUS_SSL "SSL"
#define LANG_STATUS_SSL_SECURE "安全"
#define LANG_STATUS_SSL_INSECURE "不安全"
#define LANG_STATUS_TURBO "涡轮"
#define LANG_STATUS_ACTIVE "活动"
#define LANG_STATUS_INACTIVE "非活动"
#define LANG_STATUS_AUTO_MSGS "自动消息"
#define LANG_STATUS_YES "是"
#define LANG_STATUS_NO "否"

// ========== KISSOTA.CPP =============
#define LANG_OTA_RUN_RUNN "⚠️ OTA 已在进行中"
#define LANG_OTA_PIN_BLOCK "🔒 PIN 已锁定\n\n要解锁 OTA 功能，请输入 /otapuk [PUK]\n解锁后，您可以使用 /ota 启动新进程\n\n如果您没有 PUK，请联系管理员。"
#define LANG_OTA_INI_1 "📦 OTA 更新\n\n我们将开始更新设备的固件。\n\n更新期间：\n• 消息存储在设备上\n• 您不会丢失消息\n• 您不会收到命令消息\n• 要取消进程，请发送 /otacancel\n\n输入 /otapin [PIN] 以启动进程\n\n⏱️ 您有 60 秒时间"
#define LANG_OTA_INI_TIMEOUT "⏱️ 超时\n\n输入 PIN 的时间已过期。\n进程已取消。\n\n请使用 /ota 重新开始"
#define LANG_OTA_GLOB_TIMEOUT "⏱️ OTA 超时\n\n进程已超过 7 分钟的最大时间。\n进程已取消。\n\n系统恢复正常运行。\n请使用 /ota 重新开始"
#define LANG_OTA_PIN_OK "✅ PIN 正确\n\n正在启动更新进程...\n\n• 消息已暂停\n• 检查可用空间\n• 创建当前固件备份\n\n⏱️ 进程超时：7 分钟\n\n请勿关闭设备。"
#define LANG_OTA_ERROR_BACKUP "❌ 备份错误\n\n无法创建当前固件的备份。\n进程已取消。\n\n系统恢复正常运行。\n请使用 /ota 重新开始"
#define LANG_OTA_INI_2 "✅ 备份完成\n\n当前固件已正确保存。\n\n📤 发送新固件的 .bin 文件"
#define LANG_OTA_PIN_BLOCKED "🔒 PIN 已锁定\n\n您已超过 3 次尝试上限。\n当前进程已取消。\n\n要解锁 OTA 功能，请输入 /otapuk [PUK]\n解锁后，您可以使用 /ota 启动新进程\n\n如果您没有 PUK，请联系管理员。"
#define LANG_OTA_PIN_FAIL "❌ PIN 不正确\n\n剩余尝试次数：%d\n\n输入 /otapin [PIN] 重试"
#define LANG_OTA_PIN_UBLOCK "🔓 OTA 已解锁\n\nPIN 已成功解锁。\nPIN 尝试次数已重置。\n\n要开始更新，请输入 /ota"
#define LANG_OTA_PUK_WRONG "❌ PUK 不正确"
#define LANG_OTA_PR_INACTI "❌ 没有活动的 OTA 进程"
#define LANG_OTA_REVERT "🔄 正在启动回滚\n\n正在恢复之前的固件...\n设备将重新启动。\n\n请勿关闭设备。"
#define LANG_OTA_CANCEL "🛑 进程已取消\n\n更新已被取消。\n固件未进行任何更改。\n\n系统恢复正常运行。"
#define LANG_OTA_FLASH "🔥 正在刷写固件\n\n正在写入闪存...\n这可能需要几分钟。\n\n⚠️ 请勿断开设备连接"
#define LANG_OTA_FLASH_F "❌ 刷写错误\n\n固件写入失败。\n正在启动自动回滚...\n\n设备将以之前的固件重新启动。\n\n请勿关闭设备。"
#define LANG_OTA_VALIDATED "✅ 固件已验证\n\n更新已成功完成。\n备份已删除。\n\n系统恢复正常运行。\n待处理的消息现在将被处理。（您可以忽略之前的验证消息）"
#define LANG_OTA_NONVALID "❌ 无效文件\n\n无效的文件名。\n\n请发送 .bin 固件文件"
#define LANG_OTA_WRONG_EXT "❌ 无效文件\n\n文件必须是 .bin\n收到：%s\n\n请发送有效的固件文件。"
#define LANG_OTA_TOO_BIG "❌ 文件过大\n\n大小：%.2f MB\n最大：%.2f MB\n\n请发送较小的文件。"
#define LANG_OTA_TOO_SMALL "⚠️ 文件过小\n\n大小：%.1f KB\n\n您确定这是有效的固件吗？"
#define LANG_OTA_DOWNLOADING "📥 正在下载固件\n\n正在接收文件：%s\n大小：%.2f MB\n\n请勿断开设备连接。"
#define LANG_OTA_DOWN_FAIL "❌ 下载失败\n\n3 次尝试后仍无法下载固件。\n可能原因：WiFi 连接不稳定。\n\n进程已取消。\n请使用 /ota 重新开始"
#define LANG_OTA_CHKSUM_VERI "🔍 正在验证完整性\n\n正在检查固件校验和..."
#define LANG_OTA_CHKSUM_WRONG "❌ 验证失败\n\n文件已损坏或不完整。\n\n进程已取消。\n请使用 /ota 重新开始"
#define LANG_OTA_FILE_VERIFIED "✅ 固件已验证\n\n文件：%s\n大小：%.2f MB\nCRC32：0x%08X\n⚠️确认刷写\n\n/otaconfirm - 立即刷写\n/otacancel - 取消进程\n\n超时：3 分钟"
#define LANG_OTA_PIN_OUTTIME "超时\n\n- 输入 PIN 的时间已过期。\n- 进程已中止。系统恢复正常状态。\n\n- 请使用 /ota 重新开始"
#define LANG_OTA_PIN_OUT_VAL "⏱️ 验证超时\n\n60 秒内未收到确认。\n正在启动自动回滚...\n\n设备将以之前的固件重新启动"
#define LANG_OTA_TIMEOUT "⏱️ OTA 超时\n\n进程已超过 7 分钟的最大时间。\n进程已取消。\n\n系统恢复正常运行。\n请使用 /ota 重新开始"
#define LANG_OTA_CHECK_FS "❌ 系统错误\n\n无法访问文件系统。\n进程已取消。"
#define LANG_OTA_NOT_ENOUGH "❌ 空间不足\n\n没有足够的空间创建备份。\n\n需要：%.1f MB\n可用：%.1f MB\n\n请释放空间并使用 /ota 重试"
#define LANG_OTA_BEF_REBOOT "✅ 刷写完成\n\n固件已成功写入。\n设备现在将重新启动。\n\n重启后，您有 60 秒时间使用 /otaok 进行验证\n如果未验证，将执行自动回滚。"
#define LANG_OTA_QUEUE_MESS "⚠️ OTA 已中断\n\n设备在 OTA 进程期间重新启动。\n部分下载已删除。\n\n系统恢复正常运行。\n请使用 /ota 重新开始"
#define LANG_OTA_MAINT_MODE "🔄 固件验证\n\n设备已启动。\n\n⏱️ 您有 60 秒时间验证\n\n/otaok - 确认工作正常\n/otacancel - 强制回滚到之前的固件\n\n如果无响应，将执行自动回滚。"
#define LANG_OTA_CRITI_ERROR "🔥 严重错误\n\n回滚失败。\n系统可能不稳定。\n\n需要手动干预。\n请联系管理员。"
#define LANG_OTA_ERROR_RECOVER "🔥 严重错误\n\n恢复失败。\n系统可能不稳定。\n\n需要手动干预。\n请联系管理员。"
#define LANG_OTA_RECOVER_ERROR "❌ 无可用备份\n\n无法执行恢复。\n系统保持当前固件。"

// ========== KISSTELEGRAM.CPP ========
#define LANG_ERROR_CRITICAL_FS "❌ LittleFS 初始化错误"
#define LANG_ERROR_SYSTEM_DES "🛑 KissTelegram 已销毁"
#define LANG_INFO_MAINTENANCE_ON "⏸️ 维护模式已启用: %s"
#define LANG_INFO_MAINTENANCE_OFF "▶️ 维护模式已禁用"
#define LANG_INFO_CON_RESUME "🔗 复用之前的连接"
#define LANG_INFO_CON_DIE "🔌 清理死连接"
#define LANG_INFO_CON_CLEAN "🔌 错误 %d - 清理连接"
#define LANG_INFO_FS_NEAR "❌ FS 达到 %.1f%% - 消息已丢弃"
#define LANG_INFO_FS_FULL "❌ FS 空间不足 - 消息已丢弃"
#define LANG_ERROR_FS_SAVE "❌ 保存到 LittleFS 错误"
#define LANG_INFO_MSG_SENT "🚀 Turbo: %d 已发送 (%.1f msg/s)"
#define LANG_WARN_MSG_SEND "⚠️ 从队列发送消息错误"
#define LANG_WARN_MSG_DUP "⚠️ 重复的更新已忽略: %ld"
#define LANG_WARN_MSG_LEN "⚠️ 消息长度无效: %d bytes"
#define LANG_WARN_NOID "⚠️ 消息没有有效的 chat_id - 已忽略"
#define LANG_WARN_WRLEN "⚠️ file_id 长度无效: %d bytes"
#define LANG_WARN_TSSL "🔒 尝试安全的 SSL 连接..."
#define LANG_INFO_TSYNC "💡 TimeSynced: %s", timeSynced ? "是" : "否"
#define LANG_INFO_FRAM "💡 Free Heap: %d"
#define LANG_INFO_CERT "💡 CA 证书已配置"
#define LANG_ERROR_SSLCLI "❌ sslClient 为 NULL"
#define LANG_INFO_TEST_BASIC "💡 测试基本连接性..."
#define LANG_INFO_CON_BASIC "💡 基本连接性: %s 在 %lu ms"
#define LANG_INFO_SSL_TEST "💡 SSL 连接: %s 在 %lu ms", connected ? "成功" : "失败"
#define LANG_INFO_SSL_SUCC "✅ SSL 连接成功 在 %lu ms"
#define LANG_INFO_CERT_VERI "✅ 证书验证成功"
#define LANG_INFO_CERT_FAIL "❌ 证书验证失败"
#define LANG_WARN_CERT_FAIL "⚠️ 证书未验证 (时间未同步)"
#define LANG_ERROR_SSL_FAIL "❌ SSL 连接失败 在 %lu ms 后"
#define LANG_INFO_FRRAM "💡 RAM 头: %d"
#define LANG_WARN_INSECURE "⚠️ 不安全的连接成功 在 %lu ms"
#define LANG_ERROR_INSECURE "❌ 不安全的连接失败 在 %lu ms 后"
#define LANG_INFO_SSL_MSG "SSL Info:\n - 安全: %s\n - 时间同步: %s\n - 可用内存: %d bytes\n - 客户端: %s", sslSecure ? "是" : "否", KissTime::getInstance().isTimeSynced() ? "是" : "否", ESP.getFreeHeap(), sslClient ? (sslClient->connected() ? "已连接" : "未连接") : "NULL"
#define LANG_INFO_STOR_CLEAN "🗑️ 存储已完全清理"
#define LANG_ERROR_MSG_TOLA "❌ 消息太长"
#define LANG_ERROR_MSG_WRIT "❌ 写入消息错误"
#define LANG_INFO_MSG_DEL "🗑️ 批量删除: %d 条消息已删除"
#define LANG_INFO_FLUSH "🗑️ 最终刷新 - 空队列"
#define LANG_INFO_MSG_QUEUE "📤 已处理队列中的 %d 条消息"
#define LANG_INFO_POWER_MODE "
🔋 能源:"
#define LANG_INFO_TUR_ACT "🚀 涡轮模式已激活"
#define LANG_INFO_TUR_DEAC "🐢 涡轮模式已禁用 - %d 条消息 在 %lu ms (%.1f msg/s)"
#define LANG_INFO_DIAG_1 "\n📊 KISSTELEGRAM 诊断:" KISS_SUITE_VERSION
#define LANG_INFO_DIAG_2 " - 待处理: %d"
#define LANG_INFO_DIAG_3 " - WiFi: %s", isWifiStable() ? "稳定" : "不稳定"
#define LANG_INFO_DIAG_4 " - 维护: %s", maintenanceMode ? "活跃" : "未激活"
#define LANG_INFO_DIAG_5 " - 内存: %d bytes"
#define LANG_INFO_STOR_1 "\n💾 存储 (直接 FS):"
#define LANG_INFO_STOR_2 " - 待处理: %d"
#define LANG_INFO_STATS_1 "\n🎯 状态:"
#define LANG_INFO_STATS_2 " - 待处理: %d", countPendingMessages()
#define LANG_INFO_STATS_3 " - WiFi: %s", isWifiStable() ? "是" : "否"
#define LANG_INFO_STATS_4 "\n⚙️ 配置:"
#define LANG_INFO_STATS_5 " - 间隔: %d ms"
#define LANG_INFO_STATS_6 " - 最大存储: %d"
#define LANG_INFO_FS_PEND "💾 直接 FS:\n - 待处理: %d"
#define LANG_INFO_FS_DIAG "📊 " KISS_SUITE_VERSION"-直接-FS\n - 待处理: %d\n - 内存: %d"
#define LANG_INFO_CLOSE_CON "🕒 因超时而关闭连接 (10 分钟)"
#define LANG_INFO_OTA_AUTHO "✅ OTA 已授权"
#define LANG_INFO_SSL "🔒 SSL 信息（发送至串口）"
#define LANG_INFO_SSL_TEST_0 "🧪 KissTelegram: 正在测试 SSL 连接..."
#define LANG_INFO_SSL_TEST_1 "📍 从 testSSLConnection 调用"
#define LANG_INFO_SSL_TEST_2 "✅ KissTelegram: SSL 测试成功"
#define LANG_ERROR_SSL_TEST_3 "❌ KissTelegram: SSL 测试失败"
#define LANG_INFO_CON_LIM "⏱️ 连接 Telegram 过快 限制为 (%lu ms)"
#define LANG_INFO_SSL_INTELL "🔄 自动调整 SSL: %s → %s"
#define LANG_INFO_SSL_SUCC_1 "✅ SSL 连接成功"
#define LANG_ERROR_SSL_FAIL_1 "❌ SSL 连接失败"
#define LANG_INFO_PING_TG "💓
#define LANG_INFO_PING_REP "💓 Ping 结果: %s (%d bytes)", foundOK ? "OK" : "FAIL"

#endif