#ifndef LANG_DE_H
#define LANG_DE_H

// ========== MENSAJES DE suite_kiss.ino ==========
#define LANG_HELLO_MESSAGE "🔌 Hallo.\nKommunikation hergestellt\n\n🔨 Kompiliert: %s\n🔢 Hash: 0x%08X\n📦 Version: %s\n📊 Status:\nNeustarts: %d\nBetriebszeit: %lu Sek\nFreier RAM: %d bytes\nAusstehende Nachrichten: %d\n📡 WiFi-Signal: %d dBm (%s)"

// WiFi-Signalqualität
#define LANG_WIFI_EXCELLENT "Ausgezeichnet"
#define LANG_WIFI_GOOD "Gut"
#define LANG_WIFI_FAIR "Mäßig"
#define LANG_WIFI_WEAK "Schwach"

// /estado Befehl
#define LANG_STATUS_TITLE_RELIABILITY "🎯 SYSTEMZUVERLÄSSIGKEIT"
#define LANG_STATUS_SYSTEM "System"
#define LANG_STATUS_RELIABLE "ZUVERLÄSSIG"
#define LANG_STATUS_CHECK "PRÜFEN"
#define LANG_STATUS_SENT "Gesendete Nachrichten"
#define LANG_STATUS_PENDING "Ausstehende Nachrichten"
#define LANG_STATUS_LOST "Verlorene Nachrichten"
#define LANG_STATUS_DISCARDED "Verworfen (Warteschlange voll)"
#define LANG_STATUS_TITLE_EXTERNAL "🌐 EXTERNE WIDRIGKEITEN"
#define LANG_STATUS_ERRORS "Gesamtfehler"
#define LANG_STATUS_RECOVERED "Wiederhergestellt (Fallback)"
#define LANG_STATUS_WIFI_DROPS "WiFi-Abbrüche"
#define LANG_STATUS_TITLE_TECHNICAL "📊 TECHNISCHE INFORMATIONEN"
#define LANG_STATUS_UPTIME "Betriebszeit"
#define LANG_STATUS_FREE_RAM "Freier RAM"
#define LANG_STATUS_FREE_PSRAM "Freier PSRAM"
#define LANG_STATUS_FREE_FS "Freier FS"
#define LANG_STATUS_MAX_FS "Max. in FS"
#define LANG_STATUS_MESSAGES "Nachrichten"
#define LANG_STATUS_POWER_MODE "Energiemodus"
#define LANG_STATUS_WIFI_SIGNAL "WiFi-Signal"
#define LANG_STATUS_SSL "SSL"
#define LANG_STATUS_SSL_SECURE "SICHER"
#define LANG_STATUS_SSL_INSECURE "UNSICHER"
#define LANG_STATUS_TURBO "Turbo"
#define LANG_STATUS_ACTIVE "AKTIV"
#define LANG_STATUS_INACTIVE "INAKTIV"
#define LANG_STATUS_AUTO_MSGS "Auto-Nachrichten"
#define LANG_STATUS_YES "JA"
#define LANG_STATUS_NO "NEIN"

// ========== KISSOTA.CPP =============
#define LANG_OTA_RUN_RUNN "⚠️ OTA bereits im Gange"
#define LANG_OTA_PIN_BLOCK "🔒 PIN GESPERRT\n\nUm die OTA-Funktion zu entsperren, geben Sie /otapuk [PUK] ein\nEinmal entsperrt, können Sie einen neuen Prozess mit /ota starten\n\nWenn Sie den PUK nicht haben, wenden Sie sich an den Administrator."
#define LANG_OTA_INI_1 "📦 OTA-UPDATE\n\nWir starten ein Firmware-Update für das Gerät.\n\nWährend des Updates:\n• Nachrichten werden auf dem Gerät gespeichert\n• Sie verlieren keine Nachrichten\n• Sie erhalten keine Befehlsnachrichten\n• Um den Prozess abzubrechen, senden Sie /otacancel\n\nGeben Sie /otapin [PIN] ein, um den Prozess zu starten\n\n⏱️ Sie haben 60 Sekunden"
#define LANG_OTA_INI_TIMEOUT "⏱️ TIMEOUT\n\nDie Zeit zur PIN-Eingabe ist abgelaufen.\nProzess abgebrochen.\n\nStarten Sie neu mit /ota"
#define LANG_OTA_GLOB_TIMEOUT "⏱️ OTA-TIMEOUT\n\nDer Prozess hat die maximale Zeit von 7 Minuten überschritten.\nProzess abgebrochen.\n\nDas System kehrt zum normalen Betrieb zurück.\nStarten Sie neu mit /ota"
#define LANG_OTA_PIN_OK "✅ KORREKTER PIN\n\nStarte Update-Prozess...\n\n• Nachrichten pausiert\n• Überprüfe verfügbaren Speicherplatz\n• Erstelle Backup der aktuellen Firmware\n\n⏱️ Prozess-Timeout: 7 Minuten\n\nSchalten Sie das Gerät nicht aus."
#define LANG_OTA_ERROR_BACKUP "❌ BACKUP-FEHLER\n\nKonnte kein Backup der aktuellen Firmware erstellen.\nProzess abgebrochen.\n\nDas System kehrt zum normalen Betrieb zurück.\nStarten Sie neu mit /ota"
#define LANG_OTA_INI_2 "✅ BACKUP ABGESCHLOSSEN\n\nAktuelle Firmware erfolgreich gespeichert.\n\n📤 Senden Sie die .bin-Datei der neuen Firmware"
#define LANG_OTA_PIN_BLOCKED "🔒 PIN GESPERRT\n\nSie haben das Maximum von 3 Versuchen überschritten.\nDer aktuelle Prozess wird abgebrochen.\n\nUm die OTA-Funktion zu entsperren, geben Sie /otapuk [PUK] ein\nEinmal entsperrt, können Sie einen neuen Prozess mit /ota starten\n\nWenn Sie den PUK nicht haben, wenden Sie sich an den Administrator."
#define LANG_OTA_PIN_FAIL "❌ Falscher PIN\n\nVerbleibende Versuche: %d\n\nGeben Sie /otapin [PIN] ein, um es erneut zu versuchen"
#define LANG_OTA_PIN_UBLOCK "🔓 OTA ENTSPERRT\n\nDer PIN wurde erfolgreich entsperrt.\nDie PIN-Versuche wurden zurückgesetzt.\n\nUm ein Update zu starten, geben Sie /ota ein"
#define LANG_OTA_PUK_WRONG "❌ Falscher PUK"
#define LANG_OTA_PR_INACTI "❌ Kein aktiver OTA-Prozess"
#define LANG_OTA_REVERT "🔄 ROLLBACK WIRD GESTARTET\n\nStelle vorherige Firmware wieder her...\nDas Gerät wird neu starten.\n\nSchalten Sie das Gerät nicht aus."
#define LANG_OTA_CANCEL "🛑 PROZESS ABGEBROCHEN\n\nDas Update wurde abgebrochen.\nEs wurden keine Änderungen an der Firmware vorgenommen.\n\nDas System kehrt zum normalen Betrieb zurück."
#define LANG_OTA_FLASH "🔥 FIRMWARE WIRD GEFLASHT\n\nSchreibe in Flash-Speicher...\nDies kann einige Minuten dauern.\n\n⚠️ TRENNEN SIE DAS GERÄT NICHT"
#define LANG_OTA_FLASH_F "❌ FLASH-FEHLER\n\nDas Schreiben der Firmware ist fehlgeschlagen.\nStarte automatischen Rollback...\n\nDas Gerät startet mit der vorherigen Firmware neu.\n\nSchalten Sie das Gerät nicht aus."
#define LANG_OTA_VALIDATED "✅ FIRMWARE VALIDIERT\n\nDas Update wurde erfolgreich abgeschlossen.\nBackup gelöscht.\n\nDas System kehrt zum normalen Betrieb zurück.\nAusstehende Nachrichten werden jetzt verarbeitet. (Sie können die vorherige Validierungsnachricht ignorieren)"
#define LANG_OTA_NONVALID "❌ UNGÜLTIGE DATEI\n\nUngültiger Dateiname.\n\nSenden Sie eine .bin-Firmware-Datei"
#define LANG_OTA_WRONG_EXT "❌ UNGÜLTIGE DATEI\n\nDie Datei muss .bin sein\nEmpfangen: %s\n\nSenden Sie eine gültige Firmware-Datei."
#define LANG_OTA_TOO_BIG "❌ DATEI ZU GROSS\n\nGröße: %.2f MB\nMaximum: %.2f MB\n\nSenden Sie eine kleinere Datei."
#define LANG_OTA_TOO_SMALL "⚠️ DATEI ZU KLEIN\n\nGröße: %.1f KB\n\nSind Sie sicher, dass dies eine gültige Firmware ist?"
#define LANG_OTA_DOWNLOADING "📥 FIRMWARE WIRD HERUNTERGELADEN\n\nDatei wird empfangen: %s\nGröße: %.2f MB\n\nGerät nicht trennen."
#define LANG_OTA_DOWN_FAIL "❌ DOWNLOAD FEHLGESCHLAGEN\n\nFirmware konnte nach 3 Versuchen nicht heruntergeladen werden.\nMögliche Ursache: instabile WiFi-Verbindung.\n\nProzess abgebrochen.\nStarten Sie neu mit /ota"
#define LANG_OTA_CHKSUM_VERI "🔍 ÜBERPRÜFE INTEGRITÄT\n\nÜberprüfe Firmware-Checksum..."
#define LANG_OTA_CHKSUM_WRONG "❌ VERIFIKATION FEHLGESCHLAGEN\n\nDie Datei ist beschädigt oder unvollständig.\n\nProzess abgebrochen.\nStarten Sie neu mit /ota"
#define LANG_OTA_FILE_VERIFIED "✅ FIRMWARE VERIFIZIERT\n\nDatei: %s\nGröße: %.2f MB\nCRC32: 0x%08X\n⚠️FLASH BESTÄTIGEN\n\n/otaconfirm - Jetzt flashen\n/otacancel - Prozess abbrechen\n\nTimeout: 3 Minuten"
#define LANG_OTA_PIN_OUTTIME "TIMEOUT\n\n- Die Zeit zur PIN-Eingabe ist abgelaufen.\n- Prozess abgebrochen. Das System kehrt zum Normalzustand zurück.\n\n- Starten Sie neu mit /ota"
#define LANG_OTA_PIN_OUT_VAL "⏱️ VALIDIERUNGS-TIMEOUT\n\nKeine Bestätigung innerhalb von 60 Sekunden erhalten.\nStarte automatischen Rollback...\n\nDas Gerät startet mit der vorherigen Firmware neu"
#define LANG_OTA_TIMEOUT "⏱️ OTA-TIMEOUT\n\nDer Prozess hat die maximale Zeit von 7 Minuten überschritten.\nProzess abgebrochen.\n\nDas System kehrt zum normalen Betrieb zurück.\nStarten Sie neu mit /ota"
#define LANG_OTA_CHECK_FS "❌ SYSTEMFEHLER\n\nZugriff auf das Dateisystem nicht möglich.\nProzess abgebrochen."
#define LANG_OTA_NOT_ENOUGH "❌ UNGENÜGEND SPEICHERPLATZ\n\nNicht genug Speicherplatz für das Backup.\n\nBenötigt: %.1f MB\nVerfügbar: %.1f MB\n\nSpeicherplatz freigeben und mit /ota erneut versuchen"
#define LANG_OTA_BEF_REBOOT "✅ FLASH ABGESCHLOSSEN\n\nFirmware erfolgreich geschrieben.\nDas Gerät startet jetzt neu.\n\nNach dem Neustart haben Sie 60 Sekunden, um mit /otaok zu validieren\nWenn nicht validiert, wird automatischer Rollback ausgeführt."
#define LANG_OTA_QUEUE_MESS "⚠️ OTA UNTERBROCHEN\n\nDas Gerät hat während des OTA-Prozesses neu gestartet.\nTeilweiser Download gelöscht.\n\nDas System kehrt zum normalen Betrieb zurück.\nStarten Sie neu mit /ota"
#define LANG_OTA_MAINT_MODE "🔄 FIRMWARE-VALIDIERUNG\n\nDas Gerät wurde gestartet.\n\n⏱️ Sie haben 60 Sekunden zur Validierung\n\n/otaok - Bestätigen, dass es korrekt funktioniert\n/otacancel - Rollback zur vorherigen Firmware erzwingen\n\nBei keiner Antwort wird automatischer Rollback ausgeführt."
#define LANG_OTA_CRITI_ERROR "🔥 KRITISCHER FEHLER\n\nRollback fehlgeschlagen.\nDas System könnte instabil sein.\n\nManueller Eingriff erforderlich.\nKontaktieren Sie den Administrator."
#define LANG_OTA_ERROR_RECOVER "🔥 KRITISCHER FEHLER\n\nWiederherstellung fehlgeschlagen.\nDas System könnte instabil sein.\n\nManueller Eingriff erforderlich.\nKontaktieren Sie den Administrator."
#define LANG_OTA_RECOVER_ERROR "❌ KEIN BACKUP VORHANDEN\n\nWiederherstellung nicht möglich.\nDas System behält die aktuelle Firmware."

// ========== KISSTELEGRAM.CPP ========
#define LANG_ERROR_CRITICAL_FS "❌ LittleFS Initialisierungsfehler"
#define LANG_ERROR_SYSTEM_DES "🛑 KissTelegram zerstört"
#define LANG_INFO_MAINTENANCE_ON "⏸️ Wartungsmodus aktiviert: %s"
#define LANG_INFO_MAINTENANCE_OFF "▶️ Wartungsmodus deaktiviert"
#define LANG_INFO_CON_RESUME "🔗 Vorherige Verbindung wiederverwendet"
#define LANG_INFO_CON_DIE "🔌 Tote Verbindung bereinigen"
#define LANG_INFO_CON_CLEAN "🔌 Fehler %d - Verbindung bereinigen"
#define LANG_INFO_FS_NEAR "❌ FS bei %.1f%% - Nachricht verworfen"
#define LANG_INFO_FS_FULL "❌ FS kein Speicherplatz - Nachricht verworfen"
#define LANG_ERROR_FS_SAVE "❌ Fehler beim Speichern in LittleFS"
#define LANG_INFO_MSG_SENT "🚀 Turbo: %d gesendet (%.1f msg/s)"
#define LANG_WARN_MSG_SEND "⚠️ Fehler beim Senden Nachricht aus Warteschlange"
#define LANG_WARN_MSG_DUP "⚠️ Doppeltes Update ignoriert: %ld"
#define LANG_WARN_MSG_LEN "⚠️ Nachricht mit ungültiger Länge: %d bytes"
#define LANG_WARN_NOID "⚠️ Nachricht ohne gültige chat_id - ignoriert"
#define LANG_WARN_WRLEN "⚠️ file_id mit ungültiger Länge: %d bytes"
#define LANG_WARN_TSSL "🔒 Versuche sichere SSL-Verbindung..."
#define LANG_INFO_TSYNC "💡 TimeSynced: %s", timeSynced ? "JA" : "NEIN"
#define LANG_INFO_FRAM "💡 Free Heap: %d"
#define LANG_INFO_CERT "💡 CA-Zertifikat konfiguriert"
#define LANG_ERROR_SSLCLI "❌ sslClient ist NULL"
#define LANG_INFO_TEST_BASIC "💡 Teste grundlegende Konnektivität..."
#define LANG_INFO_CON_BASIC "💡 Grundlegende Konnektivität: %s in %lu ms"
#define LANG_INFO_SSL_TEST "💡 SSL-Verbindung: %s in %lu ms", connected ? "ERFOLGREICH" : "FEHLGESCHLAGEN"
#define LANG_INFO_SSL_SUCC "✅ SSL-Verbindung erfolgreich in %lu ms"
#define LANG_INFO_CERT_VERI "✅ Zertifikat erfolgreich verifiziert"
#define LANG_INFO_CERT_FAIL "❌ Zertifikatsprüfung fehlgeschlagen"
#define LANG_WARN_CERT_FAIL "⚠️ Zertifikat nicht verifiziert (Zeit nicht synchronisiert)"
#define LANG_ERROR_SSL_FAIL "❌ SSL-Verbindung fehlgeschlagen nach %lu ms"
#define LANG_INFO_FRRAM "💡 RAM-Header: %d"
#define LANG_WARN_INSECURE "⚠️ Unsichere Verbindung erfolgreich in %lu ms"
#define LANG_ERROR_INSECURE "❌ Unsichere Verbindung fehlgeschlagen nach %lu ms"
#define LANG_INFO_SSL_MSG "SSL Info:\n - Sicher: %s\n - Zeit synchronisiert: %s\n - Freier Speicher: %d bytes\n - Client: %s", sslSecure ? "JA" : "NEIN", KissTime::getInstance().isTimeSynced() ? "JA" : "NEIN", ESP.getFreeHeap(), sslClient ? (sslClient->connected() ? "VERBUNDEN" : "GETRENNT") : "NULL"
#define LANG_INFO_STOR_CLEAN "🗑️ Speicher vollständig bereinigt"
#define LANG_ERROR_MSG_TOLA "❌ Nachricht zu lang"
#define LANG_ERROR_MSG_WRIT "❌ Fehler beim Schreiben Nachricht"
#define LANG_INFO_MSG_DEL "🗑️ Batch delete: %d Nachrichten gelöscht"
#define LANG_INFO_FLUSH "🗑️ Endgültige Spülung - leere Warteschlange"
#define LANG_INFO_MSG_QUEUE "📤 %d Nachrichten aus der Warteschlange verarbeitet"
#define LANG_INFO_POWER_MODE "
🔋 ENERGIE:"
#define LANG_INFO_TUR_ACT "🚀 TURBO MODUS AKTIVIERT"
#define LANG_INFO_TUR_DEAC "🐢 TURBO MODUS DEAKTIVIERT - %d msgs in %lu ms (%.1f msg/s)"
#define LANG_INFO_DIAG_1 "\n📊 KISSTELEGRAM DIAGNOSTIK:" KISS_SUITE_VERSION
#define LANG_INFO_DIAG_2 " - Ausstehend: %d"
#define LANG_INFO_DIAG_3 " - WiFi: %s", isWifiStable() ? "STABIL" : "INSTABIL"
#define LANG_INFO_DIAG_4 " - Wartung: %s", maintenanceMode ? "AKTIV" : "INAKTIV"
#define LANG_INFO_DIAG_5 " - Speicher: %d bytes"
#define LANG_INFO_STOR_1 "\n💾 SPEICHER (Direktes FS):"
#define LANG_INFO_STOR_2 " - Ausstehend: %d"
#define LANG_INFO_STATS_1 "\n🎯 STATUS:"
#define LANG_INFO_STATS_2 " - Ausstehend: %d", countPendingMessages()
#define LANG_INFO_STATS_3 " - WiFi: %s", isWifiStable() ? "JA" : "NEIN"
#define LANG_INFO_STATS_4 "\n⚙️ KONFIG:"
#define LANG_INFO_STATS_5 " - Intervall: %d ms"
#define LANG_INFO_STATS_6 " - Max speicher: %d"
#define LANG_INFO_FS_PEND "💾 Direktes FS:\n - Ausstehend: %d"
#define LANG_INFO_FS_DIAG "📊 " KISS_SUITE_VERSION"-Direktes-FS\n - Ausstehend: %d\n - Speicher: %d"
#define LANG_INFO_CLOSE_CON "🕒 Verbindung wegen Alter schließen (10 min)"
#define LANG_INFO_OTA_AUTHO "✅ OTA AUTORISIERT"
#define LANG_INFO_SSL "🔒 SSL INFO (an seriell gesendet)"
#define LANG_INFO_SSL_TEST_0 "🧪 KissTelegram: SSL-Verbindung testen..."
#define LANG_INFO_SSL_TEST_1 "📍 AUFGERUFEN von testSSLConnection"
#define LANG_INFO_SSL_TEST_2 "✅ KissTelegram: SSL Test ERFOLGREICH"
#define LANG_ERROR_SSL_TEST_3 "❌ KissTelegram: SSL Test FEHLGESCHLAGEN"
#define LANG_INFO_CON_LIM "⏱️ Zu schnelle Telegram-Verbindung begrenzt auf (%lu ms)"
#define LANG_INFO_SSL_INTELL "🔄 SSL automatisch anpassen: %s → %s"
#define LANG_INFO_SSL_SUCC_1 "✅ SSL-Verbindung erfolgreich"
#define LANG_ERROR_SSL_FAIL_1 "❌ SSL-Verbindung fehlgeschlagen"
#define LANG_INFO_PING_TG "💓 Keep-alive ping zu Telegram..."
#define LANG_INFO_PING_REP "💓 Ping Ergebnis: %s (%d bytes)", foundOK ? "OK" : "FEHLGESCHLAGEN"

#endif